% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_eaf_to_tex.R
\name{mc_eaf_to_tex}
\alias{mc_eaf_to_tex}
\title{Format object language texts and translations for TeX (WIP)}
\usage{
mc_eaf_to_tex(readfrom = getwd(), recursive = FALSE,
  writeto = getwd())
}
\arguments{
\item{readfrom}{Directory from which to read EAF files. Defaults to the
current working directory.}

\item{recursive}{Logical. If \code{TRUE}, the function recurses into
subdirectories.}

\item{writeto}{A directory to which to write output. Defaults to
\code{getwd}.}
}
\value{
Nothing.
}
\description{
\code{mc_eaf_to_tex} reads Multi-CAST EAF files and transforms the contents
of the \code{utterance_id}, \code{utterance}, and
\code{utterance_translation} tiers into a file with LaTeX markup that can
be rendered as a multi-column parallel text by the TeX package
\code{paracol}. Regular users of \code{multicastR} will likely find no use
for this function; it's sole purpose is to facilitate the creation of the
'Translated texts' supplementary materials included with Multi-CAST.
}
\examples{
  \dontrun{
    # read all EAF files in the current working directory,
    # then write TeX files to the same location
    mc_eaf_to_tex()
  }

}
