% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_color.R
\name{multi_color}
\alias{multi_color}
\title{Multi-color text}
\usage{
multi_color(txt = "hello world!", colors = "rainbow",
  type = "message", direction = "vertical", recycle_chars = FALSE,
  add_leading_newline = FALSE, ...)
}
\arguments{
\item{txt}{(character) Some text to color. \href{https://github.com/sckott/cowsay}{\code{cowsay}} animals are available in a list of \code{multicolor::things}, e.g. \code{things$cow}.}

\item{colors}{(character) A vector of colors, defaulting to
"rainbow", i.e. c("red", "orange", "yellow", "green", "blue", "purple").

Several out-of-the-box palettes are available; see \code{multicolor::palettes}.

Must all be \href{https://github.com/r-lib/crayon#256-colors}{\code{crayon}}-supported
colors. Any colors in \code{colors()} or hex values (see \code{?rgb})
are fair game.}

\item{type}{(character) "message" (the default), "warning", "string", or "rmd". If "rmd" is used, the type of the RMarkdown document should be \code{html_document} the chunk option \code{results = "asis"} should be used.}

\item{direction}{(character) How should the colors be spread? One of
"horizontal" or "vertical".}

\item{recycle_chars}{(logical) Should the vector of colors supplied apply to the entire string or
should it apply to each individual character (if \code{direction} is vertical)
or line (if \code{direction} is horizontal), and be recycled?}

\item{add_leading_newline}{Should a newline be added at the beginning of the text? Useful for \code{cowsay} animals when \code{type = "rmd"}.}

\item{...}{Further args.}
}
\value{
A string if \code{type} is "string", or colored
text if type is "message" or "warning"
}
\description{
Multi-color text
}
\details{
This function evenly (ish) divides up your string into
these colors in the order they appear in \code{colors}.

It cannot be used with RGUI (R.app on some systems).
}
\examples{
\dontrun{
multi_color()

multi_color("ahoy")

multi_color("taste the rainbow",
            c("rainbow", "cyan", "cyan", "rainbow"))
multi_color("taste the rainbow",
            c("mediumpurple",
              "rainbow",
             "cyan3"))

multi_color(colors = c(rgb(0.1, 0.2, 0.5),
                       "yellow",
                       rgb(0.2, 0.9, 0.1)))

multi_color(
  things$buffalo,
  c("mediumorchid4", "dodgerblue1", "lemonchiffon1"))

# Built-in color palette
multi_color(things$cow, colors = palettes$lacroix)

multi_color(cowsay:::rms, sample(colors(), 10))

# Mystery Bulgarian animal
multi_color(things[[sample(length(things), 1)]],
            c("white", "darkgreen", "darkred"),
            direction = "horizontal")

# Mystery Italian animal
multi_color(things[[sample(length(things), 1)]],
            c("darkgreen", "white", "darkred"),
            direction = "vertical")
}
}
