% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D_regularized_fold_out.R
\name{D_regularized_fold_out}
\alias{D_regularized_fold_out}
\title{Use separate data partitions for regularization and estimation across defined data folds.}
\usage{
D_regularized_fold_out(
  data,
  mv.vars,
  group.var,
  group.values,
  alpha = 0.5,
  s = "lambda.min",
  type.measure = "deviance",
  rename.output = TRUE,
  size = NULL,
  fold.var,
  pcc = FALSE,
  auc = FALSE,
  pred.prob = FALSE,
  prob.cutoffs = seq(from = 0, to = 1, by = 0.2)
)
}
\arguments{
\item{data}{A data frame.}

\item{mv.vars}{Character vector. Variable names in the multivariate variable set.}

\item{group.var}{The name of the group variable.}

\item{group.values}{Vector of length 2, group values (e.g. c("male", "female) or c(0,1)).}

\item{alpha}{Alpha-value for penalizing function ranging from 0 to 1: 0 = ridge regression, 1 = lasso, 0.5 = elastic net (default).}

\item{s}{Which lambda value is used for predicted values? Either "lambda.min" (default) or "lambda.1se".}

\item{type.measure}{Which measure is used during cross-validation. Default "deviance".}

\item{rename.output}{Logical. Should the output values be renamed according to the group.values? Default TRUE.}

\item{size}{Integer. Size of regularization data per each group. Default 1/4 of cases.}

\item{fold.var}{Name of the fold variable.}

\item{pcc}{Logical. Include probabilities of correct classification? Default FALSE.}

\item{auc}{Logical. Include area under the receiver operating characteristics? Default FALSE.}

\item{pred.prob}{Logical. Include table of predicted probabilities? Default FALSE.}

\item{prob.cutoffs}{Vector. Cutoffs for table of predicted probabilities. Default seq(0,1,0.20).}
}
\value{
\item{D}{Multivariate descriptive statistics and differences.}
\item{pred.dat}{A data.frame with predicted values.}
\item{cv.mod}{Regularized regression model from cv.glmnet.}
\item{P.table}{Table of predicted probabilities by cutoffs.}
}
\description{
Use separate data partitions for regularization and estimation across defined data folds.
}
\examples{
set.seed(34246)
n1 <- 100
n2 <- 10
d <-
  data.frame(
    sex = sample(c("male", "female"), n1 * n2, replace = TRUE),
    fold = sample(x = LETTERS[1:n2], size = n1 * n2, replace = TRUE),
    x1 = rnorm(n1 * n2),
    x2 = rnorm(n1 * n2),
    x3 = rnorm(n1 * n2)
  )
D_regularized_fold_out(
  data = d,
  mv.vars = c("x1", "x2", "x3"),
  group.var = "sex",
  group.values = c("female", "male"),
  fold.var = "fold",
  size = 17,
  pcc = TRUE
)$D
}
