% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_dadas.R
\name{ml_dadas}
\alias{ml_dadas}
\title{Predicting algebraic difference scores in multilevel model}
\usage{
ml_dadas(model, predictor, diff_var, diff_var_values)
}
\arguments{
\item{model}{Multilevel model fitted with lmerTest.}

\item{predictor}{Character string. Variable name of independent variable predicting difference score.}

\item{diff_var}{Character string. A variable indicative of difference score components (two groups).}

\item{diff_var_values}{Vector. Values of the component score groups in diff_var.}
}
\value{
A data frame including regression coefficients for component scores and dadas (One sided dadas-test for positivity of abs(b_11-b_21)-abs(b_11+b_21)).
}
\description{
Predicting algebraic difference scores in multilevel model
}
\examples{
\dontrun{
set.seed(95332)
n1 <- 10 # groups
n2 <- 10 # observations per group

dat <- data.frame(
  group = rep(c(LETTERS[1:n1]), each = n2),
  x = sample(c(-0.5, 0.5), n1 * n2, replace = TRUE),
  w = rep(sample(1:5, n1, replace = TRUE), each = n2),
  y = sample(1:5, n1 * n2, replace = TRUE)
)
library(lmerTest)
fit <- lmerTest::lmer(y ~ x * w + (x | group),
  data = dat
)

round(ml_dadas(fit,
  predictor = "w",
  diff_var = "x",
  diff_var_values = c(0.5, -0.5)
), 3)
}
}
