#' Alternate Marginal Rug Plot Geom for ggplot2
#'
#' This alternate rug plot geom simply plots the rug tufts on the top and right (instead of the bottom and left)
#' @param mapping mapping between variables and aesthetics generated by aes
#' @param data dataset used in this layer, if not specified uses plot dataset
#' @param stat statistic used by this laye
#' @param position position adjustment used by this layer
#' @param ... ignored
#' @seealso \code{\link{geom_rug}}
#'
#' @author Hadley Wickham \url{http://had.co.nz}\cr
#'
#' With contributions by:\cr
#'   William E. J. Doane \email{wil@@drdoane.com}\cr
#'   Brian A. Danielak \email{brian@@briandk.com}
#' @references Wickham, H. (2009). Ggplot2: Elegant Graphics for Data Analysis. New York: Springer.
#' @references Wilkinson, L. (1999). The Grammar of Graphics. Statistics and computing. New York: Springer.
#' @import proto
#' @export
geom_rug_alt <- function(mapping  = NULL, 
                         data     = NULL, 
                         stat     = "identity", 
                         position = "identity", 
                         ...
                ) 
{
  GeomRugAlt$new(mapping = mapping, 
              data = data, 
              stat = stat, 
              position = position, 
              ...
  )
}

GeomRugAlt <- proto(
  ggplot2:::Geom, {
    objname <- "rug_alt"

    draw <- function(., data, scales, coordinates, ...) {  
      rugs <- list()
      
      # addressing cross-compatibility with ggplot2 versions
      if (exists("coord_transform")) {
        data <- coord_transform(coordinates, data, scales)
      } else {
        data <- coordinates$transform(data, scales) # ggplot2 v0.8.9 fallback
      }

          
      if (!is.null(data$x)) {
        rugs$x <- with(data, segmentsGrob(
          x0 = unit(x, "native"), x1 = unit(x, "native"), 
          y0 = unit(1 - 0.03, "npc"), y1 = unit(1, "npc"),
          gp = gpar(col = alpha(colour, alpha), lty = linetype, lwd = size * .pt)
        ))
      }  

      if (!is.null(data$y)) {
        rugs$y <- with(data, segmentsGrob(
          y0 = unit(y, "native"), y1 = unit(y, "native"), 
          x0 = unit(1, "npc"), x1 = unit(1 - 0.03, "npc"),
          gp = gpar(col = alpha(colour, alpha), lty = linetype, lwd = size * .pt)
        ))
      }  

      gTree(children = do.call("gList", rugs))
    }

    objname <- "rug_alt"

    desc <- "Marginal rug plots"

    default_stat <- function(.) StatIdentity
    default_aes <- function(.) aes(colour="black", size=0.5, linetype=1, alpha = 1)
    guide_geom <- function(.) "path"
  }
)
