% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R, R/ops.R
\name{arrange}
\alias{arrange}
\alias{arrange_}
\title{Sort data}
\usage{
arrange(.self, ...)

arrange_(.self, ..., .dots)
}
\arguments{
\item{.self}{Data frame}

\item{...}{Additional parameters}

\item{.dots}{Workaround for non-standard evaluation}
}
\value{
Data frame
}
\description{
Sorts data frame using the columns specified
}
\details{
This function takes a parallel data frame and sorts it by the first
column specified. If there are any ties then it sorts by the second,
and so on. Use \code{desc(x)} to specify that x should be sorted in
descending order (see \code{\link{desc}}).
}
\examples{
\donttest{
dat <- Multiplyr (x=1:100, G=rep(1:4, each=25))
dat \%>\% arrange (x)
dat \%>\% arrange (G, x)
dat \%>\% shutdown()
}
}
\seealso{
Other row manipulations: \code{\link{distinct}},
  \code{\link{filter}}, \code{\link{group_by}},
  \code{\link{slice}}
}

