`planfact.as` <- function(input)
{
    ##gnre le plan factoriel complet en utilisant les vraies
    ##       modalits des paramtres

    ##ENTREES
    ## input      est une liste d'lements contenant les modalits
    ##            des diffrents paramtres


    ##SORTIES
    ## plan factoriel complet sous forme de data frame contenant
    ## les vraies modalits des inputs

    nb.niv <-1:length(input)
    for (k in 1:length(nb.niv)) {
        nb.niv[k] <- length(input[[k]])
    }
    ## Cration du plan factoriel
    plan <- planfact(nb.niv,make.factor=FALSE)
    ## Recodage des facteurs avec les valeurs transmises dans input

    echSimul <- matrix(NA,nrow(plan),ncol(plan))

    for (j in 1:ncol(plan)) {
        tmp <- input[[j]] ## modalits du facteur j
        plj <- plan[,j]+1   ## niveaux du facteur j dans le plan
        tmp <- tmp[plj]
        echSimul[,j] <- tmp

    }


    ## Rcupration des noms des variables

    if( is.null(names(input))) {  colnames(echSimul) <- colnames(plan)}
    else {                     colnames(echSimul) <- names(input[1:ncol(plan)])}

    ## Transformation du plan en dataframe
    echSimul <- as.data.frame(echSimul)

    ## Renvoi de l'chantillon
    return(echSimul)
}

