% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{multivariances.all}
\alias{multivariances.all}
\title{simultaneous computation of multivariance and total/ 2-/ 3-multivariance}
\usage{
multivariances.all(x, vec = NA, Nscale = TRUE, squared = TRUE, ...)
}
\arguments{
\item{x}{either a data matrix or a list of doubly centered distance matrices}

\item{vec}{if x is a matrix, then this indicates which columns are treated together as one sample; if x is a list, these are the indexes for which the multivariance is calculated. The default is all columns and all indexes, respectively.}

\item{Nscale}{if \code{TRUE} the multivariance is scaled up by the sample size (and thus it is exactly as required for the test of independence)}

\item{squared}{if \code{FALSE} it returns the actual multivariance, otherwise the squared multivariance (less computation)}

\item{...}{these are passed to \code{\link{cdms}} (which is only invoked if \code{x} is a matrix)}
}
\value{
Returns a vector with multivariance, total.multivariance, 2-multivariance and 3-multivariance
}
\description{
Computes simultaneously multivariance, total multivariance, 2-multivariance and 3-multivariance.
}
\details{
The computation is faster than the separate computations.
}
\examples{
x = coins(100,k = 3)
multivariances.all(x)
# yields the same as:
multivariance(x)
total.multivariance(x)
m.multivariance(x,m=2)
m.multivariance(x,m=3)


}
\seealso{
\code{\link{multivariance}}, \code{\link{total.multivariance}}, \code{\link{m.multivariance}}
}
