% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_multiverse.R
\name{parse_multiverse}
\alias{parse_multiverse}
\title{Parse the multiverse syntax to identify branches}
\usage{
parse_multiverse(.multiverse, .expr, .code, .label)
}
\arguments{
\item{.multiverse}{The multiverse object which will contain the analysis}

\item{.expr}{The expression that is being parsed}

\item{.code}{All the code that has been passed to the multiverse}

\item{.label}{The label of the code block or inside call which was used to pass the 
code being parsed into the multiverse}
}
\value{
\code{parse_multiverse()} returns a list of lists. the list of parameters and the list of conditions.
The list of parameters is a named list which defines all the values that each defined parameter can take.
The list of conditions defines, if any of the parameter values are conditional on a specific value of another
parameter, the condition.
}
\description{
In a multiverse, the user can define different values that a parameter can take using the \code{branch()} call.
The \code{parse_multiverse()} identifies the \code{branch()} calls defined in the analysis syntax and parses them into a list of
parameters and the corresponding values that each parameter can take. This function is called automatically 
and not exported.
}
