% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_version_management.R
\name{lib.is_basepackage}
\alias{lib.is_basepackage}
\title{Check if a package belongs to the standard R (base) packages.}
\usage{
lib.is_basepackage(packageName)
}
\arguments{
\item{packageName}{The package name to check.}
}
\value{
Returns logical indicating if the provided package name is a base package or not.
}
\description{
To check if the package is a base package, we look it up among all packages
in the \code{.Library} directory (\code{list.dirs(.Library, full.names = FALSE, recursive = FALSE)}).
We cannot version control packages which are located in this library since
the \code{.Library} will always be added to the \code{.libPaths}.
For base packages, this is acceptable, but it appears that this directory
is not always as clean as we would wish. Because of this reason, we do not
check the more widely accepted \code{rownames(installed.packages(priority="base"))}.
}
