% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family_branch.R
\name{add_family_branch}
\alias{add_family_branch}
\title{Add family branches to a \code{mverse} object.}
\usage{
add_family_branch(.mverse, br)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}

\item{br}{a \code{family_branch} object.}
}
\value{
The resulting \code{mverse} object.
}
\description{
This method adds a family branch to an existing \code{mverse} object.
A family branch is used to define options for the analysis distributions
when using \code{glm_mverse()}.
}
\examples{
# Define a family branch.
model_distributions <- family_branch(
  gaussian, poisson(link = "log")
)
# Create a mverse and add the branch.
mv <- create_multiverse(hurricane) \%>\%
  add_family_branch(model_distributions)
}
\seealso{
Other family branch functions: 
\code{\link{family_branch}}
}
\concept{family branch functions}
