% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.mvgam.R
\name{irf.mvgam}
\alias{irf.mvgam}
\alias{irf}
\title{Calculate latent VAR impulse response functions}
\usage{
irf(object, ...)

\method{irf}{mvgam}(object, h = 10, cumulative = FALSE, orthogonal = FALSE, ...)
}
\arguments{
\item{object}{\code{list} object of class \code{mvgam} resulting from a call to \code{\link[=mvgam]{mvgam()}}
that used a Vector Autoregressive latent process model (either as \code{VAR(cor = FALSE)} or
\code{VAR(cor = TRUE)})}

\item{...}{ignored}

\item{h}{Positive \code{integer} specifying the forecast horizon over which to calculate
the IRF}

\item{cumulative}{\code{Logical} flag indicating whether the IRF should be cumulative}

\item{orthogonal}{\code{Logical} flag indicating whether orthogonalized IRFs should be
calculated. Note that the order of the variables matters when calculating these}
}
\value{
An object of class \code{mvgam_irf} containing the posterior IRFs. This
object can be used with the supplied S3 functions \code{plot}
}
\description{
Compute Generalized or Orthogonalized Impulse Response Functions (IRFs) from
\code{mvgam} models with Vector Autoregressive dynamics
}
\details{
Generalized or Orthogonalized Impulse Response Functions can be computed
using the posterior estimates of Vector Autoregressive parameters. This function
generates a positive "shock" for a target process at time \code{t = 0} and then
calculates how  each of the remaining processes in the latent VAR are expected
to respond over the forecast horizon \code{h}. The function computes IRFs for all
processes in the object and returns them in an array that can be plotted using
the S3 \code{plot} function. To inspect community-level metrics of stability using latent
VAR processes, you can use the related \code{\link{stability}} function.
}
\examples{
\donttest{
# Simulate some time series that follow a latent VAR(1) process
simdat <- sim_mvgam(
  family = gaussian(),
  n_series = 4,
  trend_model = VAR(cor = TRUE),
  prop_trend = 1
)
plot_mvgam_series(data = simdat$data_train, series = "all")

# Fit a model that uses a latent VAR(1)
mod <- mvgam(y ~ -1,
  trend_formula = ~1,
  trend_model = VAR(cor = TRUE),
  family = gaussian(),
  data = simdat$data_train,
  chains = 2,
  silent = 2
)

# Calulate Generalized IRFs for each series
irfs <- irf(mod, h = 12, cumulative = FALSE)

# Plot them
plot(irfs, series = 1)
plot(irfs, series = 2)
plot(irfs, series = 3)

# Calculate posterior median, upper and lower 90th quantiles
# of the impulse responses
summary(irfs)
}
}
\references{
PH Pesaran & Shin Yongcheol (1998).
Generalized impulse response analysis in linear multivariate models.
Economics Letters 58: 17–29.
}
\seealso{
\code{\link{VAR}}, \code{\link{plot.mvgam_irf}}, \code{\link{stability}},
\code{\link{fevd}}
}
\author{
Nicholas J Clark
}
