% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvord.R
\docType{data}
\name{data_mvord2}
\alias{data_mvord2}
\title{Simulated credit ratings}
\format{
A data frame with 1000 rows and 10 variables
}
\usage{
data("data_mvord2", package = "mvord")
}
\description{
A simulated data set where three different raters (\code{rater1, rater2} and \code{rater3})
 assign ordinal ratings on different firms. \code{rater3} uses a different rating scale
  compared to \code{rater1} and \code{rater2}. The IDs for each subject \eqn{i} of the \eqn{n = 1000}
firms are stored in the column \code{firm_id}.
}
\details{
\itemize{
  \item \code{firm_id} firm index
  \item \code{rater1}  ordinal rating outcome of rater 1
  \item \code{rater2}  ordinal rating outcome of rater 2
  \item \code{rater3}  ordinal rating outcome of rater 3
  \item \code{X1} covariate X1
  \item \code{X2} covariate X2
  \item \code{X3} covariate X3
  \item \code{X4} covariate X4
  \item \code{X5} covariate X5
  \item \code{X6} covariate X6 (factor)
}
}
