\name{dmvSE}

\alias{dmvSE}

\title{Density function for the SE distributions.}

\description{This function computes the density function for p-variate Skew-Elliptical variables.}

\usage{dmvSE(y, X=NULL, modelType, theta, LOG=FALSE)}

\arguments{
 \item{y}{vector of quantiles. If y is a matrix, each row is considered as a quantile.}
 \item{X}{(optional) a design matrix.}
 \item{modelType}{Model specification. Already implemented modelTypes are 'N' (Normal), 'SN' (skew-normal), 'T' (Student T), and 'ST' (skew-t).}
 \item{theta}{list of parameters. The list should contain elements named 'xi' (a numeric vector) or 'B' (a kxp matrix), 'G' (a pxp matrix), 'psi' (a numeric vetor, optional) and 'nu' (a scalar, optional). See Details.}
 \item{LOG}{logical; if TRUE, log-densities are returned.}
}

\value{A numeric vector with n values of the density function, one for each row in y.}

\references{Azzalini, A. and Capitanio, A. (2003) "Distributions generated by perturbation of symmetry with emphasis on a multivariate skew t distribution", \emph{JRSSB}.}

\seealso{\code{\link{rmvSE}}.}

\examples{
# Define the parameters' list
pars = list(xi=c(5,2), G=diag(2), psi=rep(1,2), nu=4)
# Generate data
value = rmvSE(1, 2, NULL, 'ST', theta=pars)
# Compute the density function in the point y
dmvSE(y=value$y, X=NULL, modelType='ST', theta=pars, LOG=FALSE)
}
