% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.waveletCoef}
\alias{plot.waveletCoef}
\title{Multi-Resolution Analysis plot of wavelet coefficients}
\usage{
\method{plot}{waveletCoef}(x, ..., lowest = NULL, highest = NULL,
  shrinkCoef = NULL, thickness = 3, descending = FALSE, scaling = 1)
}
\arguments{
\item{x}{A list of class waveletCoef.}

\item{...}{Arguments to be passed to methods.}

\item{lowest}{Specifies the coarsest resolution to display in the Multi-resolution plot.}

\item{highest}{Specifies the finest resolution to display in the Multi-resolution plot.}

\item{shrinkCoef}{A numeric vector of trimmed wavelet coefficients to be overlayed on top of the plot for comparison with the 'x' wavelet coefficients.}

\item{thickness}{An integer that specifies the thickness of the overlayed coefficients (shrinkCoef values) in the plot. Larger values increase the thickness.}

\item{descending}{A logical value to specify whether resolutions on the y-axis of the plot are increasing from top to bottom.}

\item{scaling}{A numeric value that acts as a graphical scaling parameter to rescale the wavelet coefficients in the plot. A larger scaling value will reduce the size of the coefficients in the plot.}
}
\description{
Plots the wavelet coefficient object in the multiresolution analysis
}
\seealso{
\code{\link{multiCoef}} for generating a list of class `waveletCoef`
}

