% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/functions.R
\name{multiSigma}
\alias{multiSigma}
\title{Noise level estimation among multichannel signal}
\usage{
multiSigma(Y, deg = 3L)
}
\arguments{
\item{Y}{An input signal either an n by m matrix containing the multichannel signal to be analysed or single vector of n elements for the single channel. In the multichannel case, each of the m columns represents a channel of n observations.}

\item{deg}{The degree of the auxiliary polynomial used in the Meyer wavelet.}
}
\value{
A numeric vector of estimates of the standard deviation of the noise in each of the m channels.
}
\description{
Estimates the level of noise (standard deviation of noise) in each channel.
}
\details{
This function estimates the noise present in each channel by computing the Meyer wavelet transform of each channel of the multichannel signal. In particular, the noise level is computed by using the Median Absolute Deviation (MAD) of the wavelet coefficients at the highest possible resolution at J = floor(log2(n) - 1).
}
\examples{
library(mwaved)
# Simulate matrix of Gaussian variables with three different noise levels
sig <- c(0.25, 0.5, 1.25)
n <- 1024
Y <- sapply(1:3, function(i) sig[i]* rnorm(n))
# Estimate the noise levels
multiSigma(Y, deg = 3)
}

