% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combat_helpers.R
\name{run_combat}
\alias{run_combat}
\title{Internal function to combat-adjust for one marker}
\usage{
run_combat(marker, slide_var, ndat, remove_zeroes = TRUE, tol = 1e-04)
}
\arguments{
\item{marker}{column name of marker to normalize}

\item{slide_var}{column name of slide identifier}

\item{ndat}{multiplexed data to normalize. Data assumed to be a data.frame with cell-level data.}

\item{remove_zeroes}{boolean to remove zeroes from ComBat analysis (default=TRUE)}

\item{tol}{tolerance of ComBat algorithm (default=0.0001)}
}
\value{
ComBat adjusted values
}
\description{
Internal function to combat-adjust for one marker
}
\references{
Johnson, W. E., Li, C., & Rabinovic, A. (2007). Adjusting batch effects in microarray expression data using empirical Bayes methods. \emph{Biostatistics}, 8(1), 118-127.
}
