% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_latent_growth_curve}
\alias{simulate_latent_growth_curve}
\title{simulate_latent_growth_curve}
\usage{
simulate_latent_growth_curve(N = 100)
}
\arguments{
\item{N}{sample size}
}
\value{
data set with columns y1-y5 (observations) and t_1-t_5 (time of
observation)
}
\description{
simulate data for a latent growth curve model with five measurement occasions.
The time-distance between these occasions differs between subjects.
}
\examples{
set.seed(123)
dataset <- simulate_latent_growth_curve(N = 100)

model <- "
  I =~ 1*y1 + 1*y2 + 1*y3 + 1*y4 + 1*y5
  S =~ data.t_1 * y1 + data.t_2 * y2 + data.t_3 * y3 + data.t_4 * y4 + data.t_5 * y5

  I ~ int*1
  S ~ slp*1

  # set intercepts of manifest variables to zero
  y1 ~ 0*1; y2 ~ 0*1; y3 ~ 0*1; y4 ~ 0*1; y5 ~ 0*1;
  "

mod <- mxsem(model = model,
             data = dataset) |>
  mxTryHard()
}
