# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' clean_syntax
#'
#' takes in a lavaan style syntax and removes comments, white space, etc.
#' @param syntax lavaan style syntax
#' @return vector of strings with cleaned syntax
clean_syntax <- function(syntax) {
    .Call(`_mxsem_clean_syntax`, syntax)
}

#' find_model_name
#'
#' checks for a model name in the syntax
#' @param syntax lavaan like syntax
#' @return vector with (1) model name and (2) model syntax
#' @keywords internal
find_model_name <- function(syntax) {
    .Call(`_mxsem_find_model_name`, syntax)
}

#' parameter_table_rcpp
#'
#' creates a parameter table from a lavaan like syntax
#' @param syntax lavaan like syntax
#' @param add_intercept should intercepts for manifest variables be automatically added?
#' @param add_variance should variances for all variables be automatically added?
#' @param add_exogenous_latent_covariances should covariances between exogenous latent variables be
#' added automatically?
#' @param add_exogenous_manifest_covariances should covariances between exogenous manifest variables be
#' added automatically?
#' @param scale_latent_variance should variances of latent variables be set to 1?
#' @param scale_loading should the first loading of each latent variable be set to 1?
#' @return parameter table
parameter_table_rcpp <- function(syntax, add_intercept, add_variance, add_exogenous_latent_covariances, add_exogenous_manifest_covariances, scale_latent_variance, scale_loading) {
    .Call(`_mxsem_parameter_table_rcpp`, syntax, add_intercept, add_variance, add_exogenous_latent_covariances, add_exogenous_manifest_covariances, scale_latent_variance, scale_loading)
}

#' split_string_all
#'
#' splits a string
#' @param str string to be splitted
#' @param at where to split the string at
#' @return vector of strings
#' @keywords internal
split_string_all <- function(str, at) {
    .Call(`_mxsem_split_string_all`, str, at)
}

