% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\docType{class}
\name{mc_DataFormat-class}
\alias{mc_DataFormat-class}
\alias{mc_DataFormat}
\title{Class for logger file data format}
\description{
The Class used for parsing source data files. Typically the csv files
downloaded from microclimatic loggers. Each supported logger has established
own specific object of class \verb{mc_\{logger\}DataFormat} defining the parameters.
}
\details{
The logger definitions are stored in R environment object
\code{./data/mc_data_formats.rda}. And thus it easy to add the ability of
reading new, unsupported logger just by defining its Class parameters.
Below see e.g. the Class defining Tomst file format.

\preformatted{
An object of class "mc_TOMSTDataFormat"
attr(,"skip"): 0
attr(,"separator"): ";"
attr(,"date_column"): 2
attr(,"date_format"): NA
attr(,"na_strings"): "-200"
attr(,"columns"): list()
attr(,"filename_serial_number_pattern"): "data_(\\d+)_\\d+\\.csv$"
attr(,"data_row_pattern"): "^\\d+;[\\d.: ]+;\\d+;-?\\d+[.,]?\\d*;-?\\d+[.,]?\\d*;-?\\d+[.,]?\\d*;\\d+;\\d+;\\d+.*$"
attr(,"logger_type"): character(0)
}
}
\section{Slots}{

\describe{
\item{\code{skip}}{number of lines before data - header etc. (default 0)}

\item{\code{separator}}{columns separator (default NA)}

\item{\code{date_column}}{index of date column (default NA)}

\item{\code{date_format}}{format of date (default NA)}

\item{\code{na_strings}}{strings for NA values (default NA)}

\item{\code{error_value}}{value means error of sensor (default NA)}

\item{\code{columns}}{list with names and indexes of value columns (default list())}

\item{\code{filename_serial_number_pattern}}{character pattern for detecting serial_number from file name (default NA)}

\item{\code{data_row_pattern}}{character pattern for detecting right file format (default NA)

If data_row_pattern is NA, then file format is not validated.}

\item{\code{logger_type}}{type of logger: TMS, TMS_L45, ThermoDatalogger, Dendrometer, HOBO, ... (default NA)}

\item{\code{tz_offset}}{timezone offset in minutes from UTC in source data (default 0)}
}}

\seealso{
\link{mc_data_formats}, \linkS4class{mc_TOMSTDataFormat}, \linkS4class{mc_TOMSTJoinDataFormat}, \linkS4class{mc_HOBODataFormat}
}
