% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{mc_prep_calib}
\alias{mc_prep_calib}
\title{Sensors calibration}
\usage{
mc_prep_calib(data, localities = NULL, sensors = NULL)
}
\arguments{
\item{data}{myClim object in Raw-format or Agg-format having calibration data in metadata slot \code{sensor$calibration}}

\item{localities}{vector of locality_ids where to perform calibration, if NULL, then calibrate sensors on all localities (default NULL)}

\item{sensors}{vector of sensor names where to perform calibration see \code{names(mc_data_sensors)}; if NULL,
then calibrate all sensors having calibration parameters loaded (default NULL)}
}
\value{
same myClim object as input but with calibrated sensor values.
}
\description{
This function calibrate values of sensor (microclimatic records) using the
myClim object \code{sensor$calibration} parameters provided by \code{\link[=mc_prep_calib_load]{mc_prep_calib_load()}}.
Microclimatic records are changed and myClim object parameter \code{sensor$metadata@calibrated}
is set to TRUE. It isn't allowed to calibrate sensor multiple times.
}
\details{
This function performs calibration itself. It uses the calibration values (cor_factor, cor_slope) stored
in myClim object sensor metadata sensor calibration loaded with \code{\link[=mc_prep_calib_load]{mc_prep_calib_load()}}.
As it is possible to have multiple calibration values for one sensor in time (re-calibration after some time)
different calibration values can be applied based on the calibration time. Older microclimatic records
then first calibration \code{datetime} available are calibrated anyway (in case sensor was calibrated ex-post)
with the first calibration parameters available.

This function is not designed for TMSmoisture calibration
(conversion to volumetric water content) for this use \code{\link[=mc_calc_vwc]{mc_calc_vwc()}}

Only sensors with real value type can be calibrated. see \code{\link[=mc_data_sensors]{mc_data_sensors()}}
}
