% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_naaccr.R
\name{read_naaccr_plain}
\alias{read_naaccr_plain}
\alias{read_naaccr}
\title{Read NAACCR records}
\usage{
read_naaccr_plain(input, version = NULL, format = NULL,
  keep_fields = NULL, skip = 0, nrows = Inf, buffersize = 10000,
  encoding = getOption("encoding"))

read_naaccr(input, version = NULL, format = NULL, keep_fields = NULL,
  keep_unknown = FALSE, skip = 0, nrows = Inf, buffersize = 10000,
  encoding = getOption("encoding"), ...)
}
\arguments{
\item{input}{Either a string with a file name (containing no \code{\\n}
character), a \code{\link[base]{connection}} object, or the text records
themselves as a character vector.}

\item{version}{An integer specifying the NAACCR format version for parsing
the records. Use this or \code{format}, not both. If both \code{version}
and \code{format} are \code{NULL} (default), the most recent NAACCR format
will be used.}

\item{format}{A \code{\link{record_format}} object for parsing the records.}

\item{keep_fields}{Character vector of XML field names to keep in the
dataset. If \code{NULL} (default), all columns are kept.}

\item{skip}{An integer specifying the number of lines of the data file to
skip before beginning to read data.}

\item{nrows}{A number specifying the maximum number of records to read.
\code{Inf} (the default) means "all records."}

\item{buffersize}{Maximum number of lines to read at one time.}

\item{encoding}{String giving the input's encoding. See the 'Encoding'
section of \code{\link[base]{file}} in the \pkg{base} package.}

\item{keep_unknown}{Logical indicating whether values of "unknown" should be
a level in the factor or \code{NA}.}

\item{...}{Additional arguments passed onto \code{\link{as.naaccr_record}}.}
}
\value{
For \code{read_naaccr}, a \code{data.frame} of the records.
  The columns included depend on the NAACCR record format version.
  Columns are atomic vectors; there are too many to describe them all.

  For \code{read_naaccr_plain}, a \code{data.frame} with the columns
  specified by \code{start_cols}, \code{end_cols}, and \code{col_names}.
  All columns are character vectors.
}
\description{
Read and parse cancer incidence records according to a NAACCR format.
\code{read_naaccr} returns a data set suited for analysis in R, and
\code{read_naaccr_plain} returns a data set with the unchanged record values.
}
\details{
Anyone who wants to analyze the records in R should use \code{read_naaccr}.
In the returned \code{data.frame}, columns are of appropriate classes, coded
values are replaced with factors, and unknowns are replaced with \code{NA}.

\code{read_naaccr_plain} is a "format strict" way to read incidence records.
All values returned are the literal character values from the records.
The only processing done is that leading and trailing whitespace is trimmed.
This is useful if the values will be passed to other software that expects
the plain NAACCR values.
}
\note{
Some of the parameter text was shamelessly copied from the
  \code{\link[utils]{read.table}} and \code{\link[utils]{read.fwf}} help
  pages.
}
\examples{
  # This file has synthetic abstract records
  incfile <- system.file(
    "extdata", "synthetic-naaccr-18-abstract.txt",
    package = "naaccr"
  )
  fields <- c("ageAtDiagnosis", "sex", "sequenceNumberCentral")
  read_naaccr(incfile, version = 18, keep_fields = fields)
  recs <- read_naaccr_plain(incfile, version = 18, keep_fields = fields)
  recs
  # Note sequenceNumberCentral has been split in two: a number and a flag
  summary(recs[["sequenceNumberCentral"]])
  summary(recs[["sequenceNumberCentralFlag"]])
}
\seealso{
\code{\link{naaccr_record}}
}
