% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nabor-package.R
\name{nabor-package}
\alias{nabor-package}
\alias{nabor}
\title{Wrapper for libnabo K Nearest Neighbours C++ library}
\description{
R package \bold{nabor} wraps the 
\href{https://github.com/ethz-asl/libnabo}{libnabo} library, a fast K Nearest
Neighbour library for low-dimensional spaces written in templated C++. The 
package provides both a standalone function (see \code{\link{knn}} for basic 
queries along an option to produce an object containing the k-d tree search
(see \code{\link{WKNN}}) structure when making multiple queries against the
same target points.
}
\details{
libnabo uses the same approach as the ANN library (wrapped in R package 
\code{RANN}) but is generally faster and with a smaller memory footprint. 
Furthermore since it is templated on the underlying scalar type for 
coordinates (among other things), we have provided both float and double 
coordinate implementations of the classes wrapping the search tree 
structures. See the github repository and Elsenberg et al paper below for 
details.
}
\references{
Elseberg J, Magnenat S, Siegwart R and Nuechter A (2012). 
  "Comparison of nearest-neighbor-search strategies and implementations for 
  efficient shape registration." _Journal of Software Engineering for 
  Robotics (JOSER)_, *3*(1), pp. 2-12. ISSN 2035-3928.
}
\seealso{
\code{\link{knn}}, \code{\link{WKNN}}
}
