# Copyright (C) 2019 Victor Ordu.
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>

#' Nigeria political wards by Local Government Area
#'
#' A complete list of political wards in the Local Government Areas of Nigeria.
#' 
#' @format A data frame with 8799 rows and 2 columns:
#' \describe{
#'    \item{LGA}{Name of Local Government Area}
#'    \item{Ward}{Name of political ward}
#' }
#' 
#' @note The political ward is an important unit that is commonly used
#' for project implementation by various development sectors. For instance,
#' in many health programmes, social mapping is carried out at this level.
#' 
#' @source \url{http://www.inecnigeria.org/wp-content/uploads/2013/03/RA-LGA-ANALYSIS-NATIONWIDE.pdf}
# "ward_data" 

## TODO: Deal with this later
## The data object has been temporarily saved to 'inst'.
