% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow-recode.R
\name{recode_shadow}
\alias{recode_shadow}
\alias{recode_shadow.data.frame}
\alias{recode_shadow.grouped_df}
\title{Add special missing values to the shadow matrix}
\usage{
recode_shadow(data, ...)

\method{recode_shadow}{data.frame}(data, ...)

\method{recode_shadow}{grouped_df}(data, ...)
}
\arguments{
\item{data}{data.frame}

\item{...}{A sequence of two-sided formulas as in dplyr::case_when,
but when a wrapper function \code{.where} written around it.}
}
\value{
a dataframe with altered shadows
}
\description{
It can be useful to add special missing values, naniar supports this with
the \code{recode_shadow} function.
}
\examples{

df <- tibble::tribble(
~wind, ~temp,
-99,    45,
68,    NA,
72,    25
)

dfs <- bind_shadow(df)

dfs

recode_shadow(dfs, temp = .where(wind == -99 ~ "bananas"))

recode_shadow(dfs,
              temp = .where(wind == -99 ~ "bananas")) \%>\%
recode_shadow(wind = .where(wind == -99 ~ "apples"))

}
