% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{na_type}
\alias{na_type}
\alias{na_na}
\alias{na_bool}
\alias{na_int8}
\alias{na_uint8}
\alias{na_int16}
\alias{na_uint16}
\alias{na_int32}
\alias{na_uint32}
\alias{na_int64}
\alias{na_uint64}
\alias{na_half_float}
\alias{na_float}
\alias{na_double}
\alias{na_string}
\alias{na_large_string}
\alias{na_binary}
\alias{na_large_binary}
\alias{na_fixed_size_binary}
\alias{na_date32}
\alias{na_date64}
\alias{na_time32}
\alias{na_time64}
\alias{na_duration}
\alias{na_interval_months}
\alias{na_interval_day_time}
\alias{na_interval_month_day_nano}
\alias{na_timestamp}
\alias{na_decimal128}
\alias{na_decimal256}
\alias{na_struct}
\alias{na_sparse_union}
\alias{na_dense_union}
\alias{na_list}
\alias{na_large_list}
\alias{na_fixed_size_list}
\alias{na_map}
\alias{na_dictionary}
\alias{na_extension}
\title{Create type objects}
\usage{
na_type(
  type_name,
  byte_width = NULL,
  unit = NULL,
  timezone = NULL,
  column_types = NULL,
  item_type = NULL,
  key_type = NULL,
  value_type = NULL,
  index_type = NULL,
  ordered = NULL,
  list_size = NULL,
  keys_sorted = NULL,
  storage_type = NULL,
  extension_name = NULL,
  extension_metadata = NULL,
  nullable = NULL
)

na_na(nullable = TRUE)

na_bool(nullable = TRUE)

na_int8(nullable = TRUE)

na_uint8(nullable = TRUE)

na_int16(nullable = TRUE)

na_uint16(nullable = TRUE)

na_int32(nullable = TRUE)

na_uint32(nullable = TRUE)

na_int64(nullable = TRUE)

na_uint64(nullable = TRUE)

na_half_float(nullable = TRUE)

na_float(nullable = TRUE)

na_double(nullable = TRUE)

na_string(nullable = TRUE)

na_large_string(nullable = TRUE)

na_binary(nullable = TRUE)

na_large_binary(nullable = TRUE)

na_fixed_size_binary(byte_width, nullable = TRUE)

na_date32(nullable = TRUE)

na_date64(nullable = TRUE)

na_time32(unit = c("ms", "s"), nullable = TRUE)

na_time64(unit = c("us", "ns"), nullable = TRUE)

na_duration(unit = c("ms", "s", "us", "ns"), nullable = TRUE)

na_interval_months(nullable = TRUE)

na_interval_day_time(nullable = TRUE)

na_interval_month_day_nano(nullable = TRUE)

na_timestamp(unit = c("us", "ns", "s", "ms"), timezone = "", nullable = TRUE)

na_decimal128(precision, scale, nullable = TRUE)

na_decimal256(precision, scale, nullable = TRUE)

na_struct(column_types = list(), nullable = FALSE)

na_sparse_union(column_types = list())

na_dense_union(column_types = list())

na_list(item_type, nullable = TRUE)

na_large_list(item_type, nullable = TRUE)

na_fixed_size_list(item_type, list_size, nullable = TRUE)

na_map(key_type, item_type, keys_sorted = FALSE, nullable = TRUE)

na_dictionary(value_type, index_type = na_int32(), ordered = FALSE)

na_extension(storage_type, extension_name, extension_metadata = "")
}
\arguments{
\item{type_name}{The name of the type (e.g., "int32"). This form of the
constructor is useful for writing tests that loop over many types.}

\item{byte_width}{For \code{\link[=na_fixed_size_binary]{na_fixed_size_binary()}}, the number of bytes
occupied by each item.}

\item{unit}{One of 's' (seconds), 'ms' (milliseconds), 'us' (microseconds),
or 'ns' (nanoseconds).}

\item{timezone}{A string representing a timezone name. The empty string ""
represents a naive point in time (i.e., one that has no associated
timezone).}

\item{column_types}{A \code{list()} of \link[=as_nanoarrow_schema]{nanoarrow_schema}s.}

\item{item_type}{For \code{\link[=na_list]{na_list()}}, \code{\link[=na_large_list]{na_large_list()}}, \code{\link[=na_fixed_size_list]{na_fixed_size_list()}},
and \code{\link[=na_map]{na_map()}}, the \link[=as_nanoarrow_schema]{nanoarrow_schema} representing
the item type.}

\item{key_type}{The \link[=as_nanoarrow_schema]{nanoarrow_schema} representing the
\code{\link[=na_map]{na_map()}} key type.}

\item{value_type}{The \link[=as_nanoarrow_schema]{nanoarrow_schema} representing the
\code{\link[=na_dictionary]{na_dictionary()}} or \code{\link[=na_map]{na_map()}} value type.}

\item{index_type}{The \link[=as_nanoarrow_schema]{nanoarrow_schema} representing the
\code{\link[=na_dictionary]{na_dictionary()}} index type.}

\item{ordered}{Use \code{TRUE} to assert that the order of values in the
dictionary are meaningful.}

\item{list_size}{The number of elements in each item in a
\code{\link[=na_fixed_size_list]{na_fixed_size_list()}}.}

\item{keys_sorted}{Use \code{TRUE} to assert that keys are sorted.}

\item{storage_type}{For \code{\link[=na_extension]{na_extension()}}, the underlying value type.}

\item{extension_name}{For \code{\link[=na_extension]{na_extension()}}, the extension name. This is
typically namespaced separated by dots (e.g., arrow.r.vctrs).}

\item{extension_metadata}{A string or raw vector defining extension metadata.
Most Arrow extension types define extension metadata as a JSON object.}

\item{nullable}{Use \code{FALSE} to assert that this field cannot contain
null values.}

\item{precision}{The total number of digits representable by the decimal type}

\item{scale}{The number of digits after the decimal point in a decimal type}
}
\value{
A \link[=as_nanoarrow_schema]{nanoarrow_schema}
}
\description{
In nanoarow, types, fields, and schemas are all represented by a
\link[=as_nanoarrow_schema]{nanoarrow_schema}. These functions are convenience
constructors to create these objects in a readable way. Use \code{\link[=na_type]{na_type()}} to
construct types based on the constructor name, which is also the name that
prints/is returned by \code{\link[=nanoarrow_schema_parse]{nanoarrow_schema_parse()}}.
}
\examples{
na_int32()
na_struct(list(col1 = na_int32()))

}
