% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listdial.R
\name{listen}
\alias{listen}
\title{Listen to an Address from a Socket}
\usage{
listen(socket, url = "inproc://nanonext", autostart = TRUE)
}
\arguments{
\item{socket}{a Socket or nano object.}

\item{url}{[default 'inproc://nanonext'] a URL to dial or listen at, specifying
the transport and address as a character string e.g. 'inproc://anyvalue'
or 'tcp://127.0.0.1:5555' (see \link{transports}).}

\item{autostart}{[default TRUE] whether to start the listener. Set to FALSE
if you wish to set configuration options on the listener as it is not
generally possible to change these once started.}
}
\value{
Invisibly, an integer exit code (zero on success). A new Listener
    (object of class 'nanoListener' and 'nano') is created and bound to the
    Socket or nano object if successful.
}
\description{
Creates a new Listener and binds it to a Socket.
}
\details{
To view all Listeners bound to a socket use \code{$listener} on the
    socket, which returns a list of Listener objects. To access any individual
    Listener (e.g. to set options on it), index into the list
    e.g. \code{$listener[[1]]} to return the first Listener.

    This function may be used to bind a new Listener to a Socket,
    or else a nano object. If called on a nano object, the listener is
    attached to the object rather than the socket for ease of access, e.g.
    \code{$listener[[1]]} rather than \code{$socket$listener[[1]]}, but is
    otherwise equivalent to calling \code{listen()} on the object's socket
    directly.

    A listener is an external pointer to a listener object, which accepts
    incoming connections. A given listener object may have many connections
    at the same time, much like an HTTP server can have many connections to
    multiple clients simultaneously.
}
\section{Further details}{


    Dialers and Listeners are always associated with a single socket. A
    given socket may have multiple Listeners and/or multiple Dialers.

    The client/server relationship described by dialer/listener is completely
    orthogonal to any similar relationship in the protocols. For example, a
    rep socket may use a dialer to connect to a listener on an req socket.
    This orthogonality can lead to innovative solutions to otherwise
    challenging communications problems.

    Any configuration options on the dialer/listener should be set by
    \code{\link{setopt}} before starting the dialer/listener with
    \code{\link{start}}.

    Dialers/Listeners may be destroyed by \code{\link{close}}. They are also
    closed when their associated socket is closed.
}

\examples{
socket <- socket("req")
listen(socket, url = "tcp://127.0.0.1:6547", autostart = FALSE)
socket$listener
start(socket$listener[[1]])
socket$listener
close(socket$listener[[1]])
close(socket)

nano <- nano("bus")
listen(nano, url = "tcp://127.0.0.1:6548", autostart = FALSE)
nano$listener
start(nano$listener[[1]])
nano$listener
close(nano$listener[[1]])
nano$close()

}
