% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smat.r
\name{calc_score_matrix}
\alias{calc_score_matrix}
\title{Calculate scoring matrix from probability matrices for matching and
non-matching sets of neurons}
\usage{
calc_score_matrix(matchmat, randmat, logbase = 2, epsilon = 1e-06)
}
\arguments{
\item{matchmat}{a probability matrix given by considering 'matching' neurons.}

\item{randmat}{a probability matrix given by considering 'non-matching' or
'random' neurons.}

\item{logbase}{the base to which the logarithm should be taken to produce the
final scores.}

\item{epsilon}{a pseudocount to prevent division by zero when constructing
the log odds ratio in the probability matrix.}
}
\value{
A matrix with with \code{class=c("scoringmatrix", "table")}, with
  columns as specified by \code{dotprodbreaks} and rows as specified by
  \code{distbreaks}, containing scores for neuron segments with the given
  distance and dot product.
}
\description{
Calculate scoring matrix from probability matrices for matching and
non-matching sets of neurons
}
