% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/neuronlist.R
\name{as.neuronlist}
\alias{as.neuronlist}
\alias{as.neuronlist.default}
\title{Make a list of neurons that can be used for coordinate plotting/analysis}
\usage{
as.neuronlist(l, ...)

\method{as.neuronlist}{default}(l, df = NULL, AddClassToNeurons = TRUE, ...)
}
\arguments{
  \item{l}{An existing list or a single neuron to start a
  list}

  \item{...}{Additional arguments passed to methods}

  \item{df}{the data.frame to attach with additional
  metadata.}

  \item{AddClassToNeurons}{Whether to ensure neurons have
  class \code{neuron} (see details).}
}
\value{
neuronlist with attr('df')
}
\description{
Make a list of neurons that can be used for coordinate
plotting/analysis
}
\details{
Note that \code{as.neuronlist} can cope with both
\code{neurons} and \code{dotprops} objects but
\code{AddClassToNeurons} will only apply to things that
look like neurons but don't have a class of \code{neuron}.

See \code{\link{neuronlist}} details for more information.
}
\seealso{
\code{\link{is.neuronlist}},\code{\link{is.neuron}},\code{\link{is.dotprops}}
}

