% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/neuronlist.R
\name{plot.neuronlist}
\alias{plot.neuronlist}
\title{2D plots of the elements in a neuronlist, optionally using a subset
expression}
\usage{
\method{plot}{neuronlist}(x, subset = NULL, col = NULL, colpal = rainbow,
  add = NULL, boundingbox = NULL, ..., SUBSTITUTE = TRUE)
}
\arguments{
\item{x}{a neuron list or, for \code{plot3d.character}, a character vector of
neuron names. The default neuronlist used by plot3d.character can be set by
using \code{options(nat.default.neuronlist='mylist')}. See
?\code{\link{nat}} for details.}

\item{subset}{Expression evaluating to logical mask for neurons. See details.}

\item{col}{An expression specifying a colour evaluated in the context of the
dataframe attached to nl (after any subsetting). See details.}

\item{colpal}{A vector of colours or a function that generates colours}

\item{add}{Logical specifying whether to add data to an existing plot or make
a new one. The default value of \code{NULL} creates a new plot with the
first neuron in the neuronlist and then adds the remaining neurons.}

\item{boundingbox}{A 2 x 3 matrix (ideally of class
\code{\link{boundingbox}}) that enables the plot axis limits to be set
without worrying about axis selection or reversal (see details)}

\item{...}{options passed on to plot (such as colours, line width etc)}

\item{SUBSTITUTE}{Whether to \code{substitute} the expressions passed as
arguments \code{subset} and \code{col}. Default: \code{TRUE}. For expert
use only, when calling from another function.}
}
\value{
list of values of \code{plot} with subsetted dataframe as attribute
  \code{'df'}
}
\description{
2D plots of the elements in a neuronlist, optionally using a subset
expression
}
\details{
The col and subset parameters are evaluated in the context of the
  dataframe attribute of the neuronlist. If col evaluates to a factor and
  colpal is a named vector then colours will be assigned by matching factor
  levels against the named elements of colpal. If there is one unnamed level,
  this will be used as catch-all default value (see examples).

  If col evaluates to a factor and colpal is a function then it will be used
  to generate colours with the same number of levels as are used in col.
}
\examples{
# plot 4 cells
plot(Cell07PNs[1:4])
# modify some default plot arguments
plot(Cell07PNs[1:4], ylim=c(140,75), main='First 4 neurons')
# plot one class of neurons in red and all the others in grey
plot(Cell07PNs, col=Glomerulus, colpal=c(DA1='red', 'grey'), WithNodes=FALSE)
# subset operation
plot(Cell07PNs, subset=Glomerulus\%in\%c("DA1", "DP1m"), col=Glomerulus,
  ylim=c(140,75), WithNodes=FALSE)
}
\seealso{
\code{\link{nat-package}, \link{plot3d.neuronlist}}
}

