% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im3d.R
\name{materials}
\alias{materials}
\alias{materials.default}
\alias{materials.character}
\alias{materials.hxsurf}
\title{Extract or set the materials for an object}
\usage{
materials(x, ...)

\method{materials}{default}(x, ...)

\method{materials}{character}(x, ...)

\method{materials}{hxsurf}(x, ...)
}
\arguments{
\item{x}{An object in memory or, for \code{materials.character}, an image on 
disk.}

\item{\dots}{additional parameters passed to methods (presently ignored)}
}
\value{
A \code{data.frame} with columns \code{name, id, col}
}
\description{
\code{materials.character} will read the materials from an im3d 
  compatible image file on disk.

\code{materials.hxsurf} will extract the materials from an
  hxsurf object
}
\details{
Note that the id column will be the 1-indexed order that the
  material appears in the \code{surf$Region} list for \code{hxsurf} objects
  and the 0-indexed mask values for an image.

Presently only amiramesh images are supported since they have a
  standardised way of encoding labels, whereas nrrds would have to use
  key-value pairs according to some ad hoc convention.
}
\seealso{
Other hxsurf: 
\code{\link{as.hxsurf}()},
\code{\link{as.mesh3d}()},
\code{\link{plot3d.hxsurf}()},
\code{\link{read.hxsurf}()},
\code{\link{subset.hxsurf}()},
\code{\link{write.hxsurf}()}
}
\concept{hxsurf}
