% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns_data.R
\name{ns_data}
\alias{ns_data}
\title{NatureServe data}
\usage{
ns_data(uid, key = NULL, ...)
}
\arguments{
\item{uid}{(character) a species UID, e.g., ELEMENT_GLOBAL.2.100925}

\item{key}{(character) API key. Required. See \strong{Authentication} below
for more.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a named list, with possible slots:
\itemize{
 \item natureserve_uri
 \item classification
 \item economicAttributes
 \item license
 \item references
 \item conservationStatus
 \item managementSummary
 \item distribution
}
}
\description{
NatureServe data
}
\section{Authentication}{

Get an API key from NatureServe at
\url{https://services.natureserve.org/developer/index.jsp}.
You can pass your token in as an argument or store it one of two places:

\itemize{
  \item your .Rprofile file with an entry like
  \code{options(NatureServeKey = "your-natureserve-key")}
  \item your .Renviron file with an entry like
  \code{NATURE_SERVE_KEY=your-natureserve-key}
}

See \code{\link{Startup}} for information on how to create/find your
.Rrofile and .Renviron files
}

\section{National (N) and Subnational (S) Conservation Status Ranks}{

\itemize{
 \item NX,SX - Presumed Extirpated - Species or community is believed to be
 extirpated from the nation or state/province. Not located despite intensive
 searches of historical sites and other appropriate habitat, and virtually
 no likelihood that it will be rediscovered.
 \item NH,SH - Possibly Extirpated (Historical) - Species or community
 occurred historically in the nation or state/province, and there is some
 possibility that it may be rediscovered. Its presence may not have been
 verified in the past 20-40 years. A species or community could become NH
 or SH without such a 20-40 year delay if the only known occurrences in a
 nation or state/province were destroyed or if it had been extensively and
 unsuccessfully looked for. The NH or SH rank is reserved for species or
 communities for which some effort has been made to relocate occurrences,
 rather than simply using this status for all elements not known from
 verified extant occurrences.
 \item N1,S1 - Critically Imperiled - Critically imperiled in the nation or
 state/province because of extreme rarity (often 5 or fewer occurrences)
 or because of some factor(s) such as very steep declines making it
 especially vulnerable to extirpation from the state/province.
 \item N2,S2 - Imperiled - Imperiled in the nation or state/province because
 of rarity due to very restricted range, very few populations (often 20 or
 fewer), steep declines, or other factors making it very vulnerable to
 extirpation from the nation or state/province.
 \item N3,S3 - Vulnerable - Vulnerable in the nation or state/province due
 to a restricted range, relatively few populations (often 80 or fewer),
 recent and widespread declines, or other factors making it vulnerable
 to extirpation.
 \item N4,S4 - Apparently Secure - Uncommon but not rare; some cause for
 long-term concern due to declines or other factors.
 \item N5,S5 - Secure - Common, widespread, and abundant in the nation or
 state/province.
 \item NNR,SNR - Unranked - Nation or state/province conservation status
 not yet assessed.
 \item NU,SU - Unrankable - Currently unrankable due to lack of information
 or due to substantially conflicting information about status or trends.
 \item NNA,SNA - Not Applicable - A conservation status rank is not
 applicable because the species is not a suitable target for conservation
 activities.
}
}

\section{Breeding Status Qualifiers}{

\itemize{
 \item B - Breeding - Conservation status refers to the breeding population of
 the species in the nation or state/province.
 \item N - Nonbreeding - Conservation status refers to the non-breeding
 population of the species in the nation or state/province.
 \item M - Migrant - Migrant species occurring regularly on migration at
 particular staging areas or concentration spots where the species might
 warrant conservation attention. Conservation status refers to the
 aggregating transient population of the species in the nation or
 state/province.
}
}
\examples{
\dontrun{
## single id
(res <- ns_data(uid = 'ELEMENT_GLOBAL.2.100925'))
## many ids at once
res <- ns_data(uid = c('ELEMENT_GLOBAL.2.100925', 'ELEMENT_GLOBAL.2.104470'))
res$ELEMENT_GLOBAL.2.100925
res$ELEMENT_GLOBAL.2.104470
}
}
\references{
\url{https://services.natureserve.org/index.jsp}
}

