% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_main.R
\name{print.nbc_summary}
\alias{print.nbc_summary}
\title{Print top predicted causes from a NBC model}
\usage{
\method{print}{nbc_summary}(x, ...)
}
\arguments{
\item{x}{A \code{\link{summary.nbc}} object.}

\item{...}{Additional arguments to be passed if applicable.}
}
\description{
Prints a summary message from a \code{\link{summary.nbc}} object of
the top causes by probability or predicted Cause Specific Mortality Fraction (CSMF). \cr \cr
\figure{printnbcex.png}
}
\details{
See \href{https://rrwen.github.io/nbc4va/methods}{Methods documentation} for details on CSMF and probability from the Naive Bayes Classifier.
}
\examples{
library(nbc4va)
data(nbc4vaData)

# Run naive bayes classifier on random train and test data
train <- nbc4vaData[1:50, ]
test <- nbc4vaData[51:100, ]
results <- nbc(train, test)

# Print a summary of all the test data for the top 3 causes by predicted CSMF
brief <- summary(results, top=3)
print(brief)

}
\seealso{
Other main functions: \code{\link{nbc}},
  \code{\link{plot.nbc}}, \code{\link{summary.nbc}}
}
