% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.simulation}
\alias{plot.simulation}
\title{Visualize an N-body simulation}
\usage{
\method{plot}{simulation}(
  x,
  y,
  units = 1,
  index1 = 1,
  index2 = 2,
  xlim = NULL,
  ylim = NULL,
  center = c(0, 0, 0),
  cex = 0.3,
  pch = 20,
  title = "",
  asp = 1,
  pty = "m",
  col = "black",
  alpha.orbits = 1,
  alpha.snapshots = 1,
  lwd = 1,
  show.orbits = TRUE,
  show.snapshots = TRUE,
  show.ics = TRUE,
  show.fcs = TRUE,
  ...
)
}
\arguments{
\item{x}{is a simulation-object as produced by \code{run.simulation}}

\item{y}{deprecated argument included for consistency with generic \code{\link[graphics]{plot}} function}

\item{units}{length unit in SI units}

\item{index1}{index of the dimension plotted on the x-axis}

\item{index2}{index of the dimension plotted on the y-axis}

\item{xlim}{2-vector specifying the plotting range along the x-axis}

\item{ylim}{2-vector specifying the plotting range along the y-axis}

\item{center}{3-vector specifying the plotting center in the specified units}

\item{cex}{point size}

\item{pch}{point type}

\item{title}{title of plot}

\item{asp}{aspect ratio of x and y axes}

\item{pty}{character specifying the type of plot region to be used; "s" generates a square plotting region and "m" generates the maximal plotting region.}

\item{col}{either (1) a single color, (2) a n-element vector of colors for each particle or (3) a function(n,...) producing n colors, e.g. 'rainbow'}

\item{alpha.orbits}{opacity (0...1) of orbital lines.}

\item{alpha.snapshots}{opacity (0...1) of snapshot points.}

\item{lwd}{line width of orbital lines.}

\item{show.orbits}{logical flag. If TRUE (default), the orbits are shown as straight lines between snapshots.}

\item{show.snapshots}{logical flag. If TRUE (default), points are shown for each snapshot.}

\item{show.ics}{logical flag. If TRUE (default), the initial positions are highlighted.}

\item{show.fcs}{logical flag. If TRUE (default), the final positions are highlighted.}

\item{...}{additional parameters for \code{\link[graphics]{plot}}}
}
\value{
None
}
\description{
Basic routine to visualise the result of an N-body simulation, projected onto a plane.
}
\author{
Danail Obreschkow
}
