% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{lisa.nc}
\alias{lisa.nc}
\title{Non-centered inidcators of spatial association}
\usage{
lisa.nc(x, y, z, neigh, na.rm = FALSE, resamp = 1000, latlon = FALSE,
  quiet = FALSE)
}
\arguments{
\item{x}{vector of length n representing the x coordinates (or latitude; see latlon).}

\item{y}{vector of length n representing the y coordinates (or longitude).}

\item{z}{a matrix of dimension n x p representing p (>1) observation at each location.}

\item{neigh}{neighborhood size.}

\item{na.rm}{If TRUE, NA's will be dealt with through pairwise deletion of missing values.}

\item{resamp}{number of resamples under the NULL to generate p-values}

\item{latlon}{If TRUE, coordinates are latitude and longitude.}

\item{quiet}{If TRUE, the counter is supressed during execution.}
}
\value{
An object of class "lisa.nc" is returned, consisting of the following components:
\item{correlation}{the mean correlation within the neighborhood (neigh).}
\item{p}{the permutation two-sided p-value for each distance-class.}
\item{n}{the number of pairs within each neighborhood.}
\item{dmean}{the actual mean of distance within each neighborhood.}
\item{coord}{a list with the x and y coordinates.}
}
\description{
\code{lisa.nc} is a function to estimate the (noncentred) multivariate local indicators of spatial association. The function requires multiple observations at each location. For single observations at each location use \code{lisa}.
}
\details{
This is the function to estimate the (non-centered) local indicators of spatial 
association modified form Anselin (1995). 'correlation' is the average correlation within 
a neighborhood. The function requires multiple observations at each location.

  Missing values are allowed -- values are assumed missing at random, and pairwise complete observations will be used.
}
\examples{
# first generate some sample data
x <- expand.grid(1:20, 1:5)[, 1]
y <- expand.grid(1:20, 1:5)[,2]

# z data from an exponential random field
z <- cbind(
  rmvn.spa(x = x, y = y, p = 2, method = "exp"), 
  rmvn.spa(x = x, y = y, p = 2, method = "exp")
  )

# lisa.nc analysis
fit1 <- lisa.nc(x = x, y = y, z = z, neigh = 3)
\dontrun{plot(fit1)}
}
\references{
Anselin, L. 1995. Local indicators of spatial association - LISA. Geographical Analysis 27:93-115. \url{https://doi.org/10.1111/j.1538-4632.1995.tb00338.x}
}
\seealso{
\code{\link{lisa}}, \code{\link{plot.lisa.nc}}
}
\author{
Ottar N. Bjornstad \email{onb1@psu.edu}
}
\keyword{spatial}
