% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duncan.R
\name{duncan}
\alias{duncan}
\title{Dissimilarity Index based on Duncan & Duncan (1955)}
\usage{
duncan(
  geo_large = "county",
  geo_small = "tract",
  year = 2020,
  subgroup,
  subgroup_ref,
  omit_NAs = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{geo_large}{Character string specifying the larger geographical unit of the data. The default is counties \code{geo_large = "county"}.}

\item{geo_small}{Character string specifying the smaller geographical unit of the data. The default is census tracts \code{geo_large = "tract"}.}

\item{year}{Numeric. The year to compute the estimate. The default is 2020, and the years 2009 onward are currently available.}

\item{subgroup}{Character string specifying the racial/ethnic subgroup(s) as the comparison population. See Details for available choices.}

\item{subgroup_ref}{Character string specifying the racial/ethnic subgroup(s) as the reference population. See Details for available choices.}

\item{omit_NAs}{Logical. If FALSE, will compute index for a larger geographical unit only if all of its smaller geographical units have values. The default is TRUE.}

\item{quiet}{Logical. If TRUE, will display messages about potential missing census information. The default is FALSE.}

\item{...}{Arguments passed to \code{\link[tidycensus]{get_acs}} to select state, county, and other arguments for census characteristics}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{di}}{An object of class 'tbl' for the GEOID, name, and DI at specified larger census geographies.}
\item{\code{di_data}}{An object of class 'tbl' for the raw census values at specified smaller census geographies.}
\item{\code{missing}}{An object of class 'tbl' of the count and proportion of missingness for each census variable used to compute DI}
}
}
\description{
Compute the aspatial Dissimilarity Index (Duncan & Duncan) of selected racial/ethnic subgroup(s) and U.S. geographies
}
\details{
This function will compute the aspatial Dissimilarity Index (DI) of selected racial/ethnic subgroups and U.S. geographies for a specified geographical extent (e.g., the entire U.S. or a single state) based on Duncan & Duncan (1955) \doi{10.2307/2088328}. This function provides the computation of DI for any of the U.S. Census Bureau race/ethnicity subgroups (including Hispanic and non-Hispanic individuals).

The function uses the \code{\link[tidycensus]{get_acs}} function to obtain U.S. Census Bureau 5-year American Community Survey characteristics used for the aspatial computation. The yearly estimates are available for 2009 onward when ACS-5 data are available but are available from other U.S. Census Bureau surveys. The twenty racial/ethnic subgroups (U.S. Census Bureau definitions) are:
\itemize{
\item{B03002_002: }{not Hispanic or Latino "NHoL"}
\item{B03002_003: }{not Hispanic or Latino, white alone "NHoLW"}
\item{B03002_004: }{not Hispanic or Latino, Black or African American alone "NHoLB"}
\item{B03002_005: }{not Hispanic or Latino, American Indian and Alaska Native alone "NHoLAIAN"}
\item{B03002_006: }{not Hispanic or Latino, Asian alone "NHoLA"}
\item{B03002_007: }{not Hispanic or Latino, Native Hawaiian and Other Pacific Islander alone "NHoLNHOPI"}
\item{B03002_008: }{not Hispanic or Latino, Some other race alone "NHoLSOR"}
\item{B03002_009: }{not Hispanic or Latino, Two or more races "NHoLTOMR"}
\item{B03002_010: }{not Hispanic or Latino, Two races including Some other race "NHoLTRiSOR"}
\item{B03002_011: }{not Hispanic or Latino, Two races excluding Some other race, and three or more races "NHoLTReSOR"}
\item{B03002_012: }{Hispanic or Latino "HoL"}
\item{B03002_013: }{Hispanic or Latino, white alone "HoLW"}
\item{B03002_014: }{Hispanic or Latino, Black or African American alone "HoLB"}
\item{B03002_015: }{Hispanic or Latino, American Indian and Alaska Native alone "HoLAIAN"}
\item{B03002_016: }{Hispanic or Latino, Asian alone "HoLA"}
\item{B03002_017: }{Hispanic or Latino, Native Hawaiian and Other Pacific Islander alone "HoLNHOPI"}
\item{B03002_018: }{Hispanic or Latino, Some other race alone "HoLSOR"}
\item{B03002_019: }{Hispanic or Latino, Two or more races "HoLTOMR"}
\item{B03002_020: }{Hispanic or Latino, Two races including Some other race "HoLTRiSOR"}
\item{B03002_021: }{Hispanic or Latino, Two races excluding Some other race, and three or more races "HoLTReSOR"}
}

Use the internal \code{state} and \code{county} arguments within the \code{\link[tidycensus]{get_acs}} function to specify geographic extent of the data output.

DI is a measure of the evenness of racial/ethnic residential segregation when comparing smaller geographical areas to larger ones within which the smaller geographical areas are located. DI can range in value from 0 to 1 and represents the proportion of racial/ethnic subgroup members that would have to change their area of residence to achieve an even distribution within the larger geographical area under conditions of maximum segregation.

Larger geographies available include state \code{geo_large = "state"}, county \code{geo_large = "county"}, and census tract \code{geo_large = "tract"} levels. Smaller geographies available include, county \code{geo_small = "county"}, census tract \code{geo_small = "tract"}, and census block group \code{geo_small = "block group"} levels. If a larger geographical area is comprised of only one smaller geographical area (e.g., a U.S county contains only one census tract), then the DI value returned is NA.
}
\examples{
\dontrun{
# Wrapped in \dontrun{} because these examples require a Census API key.
  
  # Dissimilarity Index of non-Hispanic Black vs. non-Hispanic white populations
  ## of census tracts within Georgia, U.S.A., counties (2020)
  duncan(geo_large = "county", geo_small = "tract", state = "GA",
         year = 2020, subgroup = "NHoLB", subgroup_ref = "NHoLW")
  
}

}
\seealso{
\code{\link[tidycensus]{get_acs}} for additional arguments for geographic extent selection (i.e., \code{state} and \code{county}).
}
