# Neighbr
#
# Copyright (c) 2017 Zementis, Inc. 
#
# This file is part of the Neighbr package for R.
#
# The Neighbr package is free software: you can redistribute it and/or 
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 2 of 
# the License, or (at your option) any later version.
#
# The Neighbr package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. Please see the
# GNU General Public License for details (http://www.gnu.org/licenses/).
######################################################################################


#' neighbr: A package for computing nearest neighbors.
#'
#' Classification, regression, and clustering with k nearest neighbors.
#'
#' @section Neighbr functions:
#' The package contains a function for running the nearest neighbors algorithm,
#' as well as functions to directly compute distances between two vectors.
#'
#' @section More information:
#' \code{\link{knn}} documents the main \code{knn} function.
#'
#' \code{\link{distance}} and \code{\link{similarity}} provide details on standalone measures.
#'
#' For more details and examples, see the vignette by running the following:
#'
#' \code{vignette("neighbr-help")}
#'
#'
#' @docType package
#' @name neighbr
NULL
