% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPackage.R
\name{getPackage}
\alias{getPackage}
\title{Get NEON data package}
\usage{
getPackage(dpID, site_code, year_month, package = "basic",
  savepath = getwd())
}
\arguments{
\item{dpID}{The identifier of the NEON data product to pull, in the form DPL.PRNUM.REV, e.g. DP1.10023.001}

\item{site_code}{A four-letter NEON research site code, such as HEAL for Healy.}

\item{year_month}{The year and month of interest, in format YYYY-MM.}

\item{package}{Either 'basic' or 'expanded', indicating which data package to download. Defaults to basic.}

\item{savepath}{The location to save the output files to}
}
\value{
A zipped monthly file
}
\description{
Get a zipped file for a single data product, site, and year-month combination. Use the NEON data portal or API to determine data
availability by data product, site, and year-month combinations.
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Christine Laney \email{claney@battelleecology.org}
}
