% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_db.R
\name{neon_db}
\alias{neon_db}
\title{Cache-able duckdb database connection}
\usage{
neon_db(dir = neon_db_dir(), read_only = TRUE, ...)
}
\arguments{
\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}

\item{read_only}{allow concurrent connections by enforcing read_only.
See details.}

\item{...}{additional arguments to dbConnect}
}
\description{
Cache-able duckdb database connection
}
\details{
Creates a connection to a permanent duckdb database
instance in the provided directory (see \code{\link[=neon_dir]{neon_dir()}}).  This
connection is also cached, so that code which repeatedly calls
\verb{[neon_db]} will not stall or hang.  Only \code{read_only} connections
will be cached.

NOTE: \verb{[duckdb::duckdb()]} can only support a single read-write connection
at a time.  The default option of \code{read_only = TRUE} allows
multiple connections. \verb{[neon_store()]} will automatically set this to
\code{FALSE} to allow data import.
}
\examples{

# tempfile used for illustration only
neon_db(tempfile())

}
