% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{counts}
\alias{counts}
\alias{counts.download}
\alias{counts.download_list}
\title{Access proxy count data}
\usage{
counts(obj, ...)

\method{counts}{download}(obj, ...)

\method{counts}{download_list}(obj, ...)
}
\arguments{
\item{obj}{an R object from which counts are to be extracted.}

\item{...}{arugments passed to other methods.}
}
\value{
Either a data frame of counts or a list of such objects.
}
\description{
Extract pollen or other proxy counts from data objects and returns them in a useful format.
}
\details{
Methods are available for "download" and "download_list" objects.
}
\examples{
\dontrun{
marion <- get_site('Marion Lake\%')
louise <- get_site('Louise Pond\%')
western.sites <- rbind(marion, louise)
western.data  <- get_dataset(western.sites)

western.dl <- get_download(western.data)
western.cnt <- counts(western.dl)
sapply(western.cnt, dim)
marion.cnt<- counts(western.dl[[1]])
dim(marion.cnt)
}
}
\author{
Gavin Simpson
}

