% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{taxa}
\alias{taxa}
\alias{taxa.download}
\alias{taxa.download_list}
\title{Access proxy taxonomic data}
\usage{
taxa(obj, ...)

\method{taxa}{download}(obj, ...)

\method{taxa}{download_list}(obj, collapse = TRUE, hierarchy = FALSE,
  ...)
}
\arguments{
\item{obj}{an R object from which counts are to be extracted.}

\item{...}{arguments passed to other methods.}

\item{collapse}{should the results be returned as a list, one for each site (\code{FALSE}), or a single dataframe of all taxa? Default is \code{TRUE}}

\item{hierarchy}{Should the taxonomic hierarchy be included?}
}
\value{
Either a data frame of taxa or a list of such objects.
}
\description{
Extracts taxa from \code{download} objects and returns them in a useful format.
}
\details{
Methods are available for "download" and "download_list" objects.
}
\examples{
\dontrun{
ostracodes <- get_dataset(datasettype = 'ostracode')

ostro.dl <- get_download(ostracodes)
ostro.taxa <- taxa(ostro.dl)
}
}
\author{
Simon Goring
}
