% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_publications.R
\name{set_publications}
\alias{set_publications}
\title{Create a new publication (or publication set)}
\usage{
set_publications(
  publicationid = NA_integer_,
  publicationtypeid = NA_integer_,
  publicationtype = NA_character_,
  year = NA_character_,
  citation = NA_character_,
  articletitle = NA_character_,
  journal = NA_character_,
  volume = NA_character_,
  issue = NA_character_,
  pages = NA_character_,
  citationnumber = NA_character_,
  doi = NA_character_,
  booktitle = NA_character_,
  numvolumes = NA_character_,
  edition = NA_character_,
  volumetitle = NA_character_,
  seriestitle = NA_character_,
  seriesvolume = NA_character_,
  publisher = NA_character_,
  url = NA_character_,
  city = NA_character_,
  state = NA_character_,
  country = NA_character_,
  originallanguage = NA_character_,
  notes = NA_character_,
  author = NULL
)
}
\arguments{
\item{publicationid}{ID of publication}

\item{publicationtypeid}{ID of kind of publication}

\item{publicationtype}{A text string identifying the publication
type within the Neotoma database.}

\item{year}{The year of publication.}

\item{citation}{A full text citation for the article.}

\item{articletitle}{The title of the article.}

\item{journal}{The journal in which the article was published.}

\item{volume}{The journal volume.}

\item{issue}{The journal issue.}

\item{pages}{The pages of the journal.}

\item{citationnumber}{How many times has the paper been cited?}

\item{doi}{A DOI for the record.}

\item{booktitle}{The title of the book (if the publication is a book)}

\item{numvolumes}{The number of book volumes (if a series)}

\item{edition}{The book edition.}

\item{volumetitle}{The title of the volume (in a published series)}

\item{seriestitle}{The title of the series.}

\item{seriesvolume}{The series volume.}

\item{publisher}{The publisher.}

\item{url}{Publication URL}

\item{city}{City of publication.}

\item{state}{State of publication.}

\item{country}{Country of publication.}

\item{originallanguage}{Original language of publication.}

\item{notes}{Publication notes.}

\item{author}{name of the author of publication.}
}
\value{
\code{publication} object
}
\description{
A function to create new publication objects by hand.
}
