% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean.collunits}
\alias{clean.collunits}
\title{clean sites objects to remove duplicates.}
\usage{
\method{clean}{collunits}(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{sites, datasets, collunits that may have duplicates.}

\item{verbose}{parameter to prints out progress bar}

\item{...}{Additional parameters associated with the call.}
}
\value{
cleaned \code{collunits}
}
\description{
Function that removes duplicate objects such as sites,
datasets, or collection units.
}
\examples{
\donttest{
clean_cols <- get_sites(sitename = "L\%", limit = 1) \%>\%
  collunits()
more_cols <- get_sites(sitename = "La\%", limit = 1) \%>\%
  collunits()
long_set <- c(clean_cols, more_cols)
length(long_set)
# By removing duplicates we get a smaller object.
length(clean(long_set))
}
}
\author{
Simon Goring \email{goring@wisc.edu}
}
