% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_pa_homophilic.R
\name{sample_pa_homophilic}
\alias{sample_pa_homophilic}
\title{Homophilic random graph using BA preferential attachment model}
\usage{
sample_pa_homophilic(
  n,
  m,
  minority_fraction,
  h_ab,
  h_ba = NULL,
  directed = FALSE
)
}
\arguments{
\item{n}{number of nodes}

\item{m}{number of edges a new node is connected to}

\item{minority_fraction}{fraction of nodes that belong to the minority group}

\item{h_ab}{probability to connect a node from group a with groub b}

\item{h_ba}{probability to connect a node from group b with groub a. If NULL, h_ab is used.}

\item{directed}{should a directed network be created}
}
\value{
igraph object
}
\description{
A graph of n nodes is grown by attaching new nodes each with m
edges that are preferentially attached to existing nodes with high
degree, depending on the homophily parameters.
}
\details{
The code is an adaption of the python code from https://github.com/gesiscss/HomophilicNtwMinorities/
}
\references{
Karimi, F., Génois, M., Wagner, C., Singer, P., & Strohmaier, M. (2018). Homophily influences ranking of minorities in social networks. Scientific reports, 8(1), 1-12. (https://www.nature.com/articles/s41598-018-29405-7)

Espín-Noboa, L., Wagner, C., Strohmaier, M., & Karimi, F. (2022). Inequality and inequity in network-based ranking and recommendation algorithms. Scientific reports, 12(1), 1-14. (https://www.nature.com/articles/s41598-022-05434-1)
}
\author{
David Schoch
#maximally heterophilic network
sample_pa_homophilic(n = 50, m = 2,minority_fraction = 0.2,h_ab = 1)
#maximally homophilic network
sample_pa_homophilic(n = 50, m = 2,minority_fraction = 0.2,h_ab = 0)
}
