% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_SW.R
\name{make_SW}
\alias{make_SW}
\title{Makes a Small-World Network}
\usage{
make_SW(size, rewire, neighborhood, net_kind = "matrix", directed = FALSE)
}
\arguments{
\item{size}{The number of nodes in the network. Must be a positive integer.}

\item{rewire}{Small-World parameter specifying the probability each edge is randomly rewired, allowing for the possiblity of bridges between connected communities.}

\item{neighborhood}{The range of nodes that form connected communities. Note: This implementation results in overlap of communities.}

\item{net_kind}{The format of the network. Currently must be either `matrix` or `list`.x}

\item{directed}{Binary variable determining if the network is directed, resulting in off-diagonal asymmetry in the adjacency matrix. Defaults to TRUE.}
}
\value{
An adjacency matrix.
}
\description{
Make an already existing network according to the Small-World mechanism.
}
\details{
Rewires a node in a network according to the Small-World mechanism.
}
\examples{
# Import netcom
library(netcom)

# Network size (number of nodes)
size <- 10

# Rewiring parameter
rewire <- 0.2

# Make network according to the Small-World mechanism
make_SW(size = size, net_kind = "matrix", rewire = rewire)

}
\references{
Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of ‘small-world’networks. nature, 393(6684), 440-442.
}
