% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{hazard_rate}
\alias{hazard_rate}
\alias{plot_hazarrate}
\alias{plot_hazard}
\alias{plot.diffnet_hr}
\title{Network Hazard Rate}
\usage{
hazard_rate(obj, no.plot = FALSE, include.grid = TRUE, ...)

plot_hazard(x, ...)

\method{plot}{diffnet_hr}(x, y = NULL, main = "Hazard Rate",
  xlab = "Time", ylab = "Hazard Rate", type = "b", include.grid = TRUE,
  bg = "lightblue", pch = 21, add = FALSE, ylim = c(0, 1), ...)
}
\arguments{
\item{obj}{A \eqn{n\times T}{n * T} matrix (Cumulative adoption matrix obtained from
\code{\link{toa_mat}}) or a \code{\link{diffnet}} object.}

\item{no.plot}{Logical scalar. When TRUE, suppress plotting (only returns hazard rates).}

\item{include.grid}{Logical scalar. When TRUE includes a grid on the plot.}

\item{...}{further arguments to be passed to the method.}

\item{x}{An object of class \code{diffnet_hr}.}

\item{y}{ignored.}

\item{main}{Character scalar. Title of the plot}

\item{xlab}{Character scalar. x-axis label.}

\item{ylab}{Character scalar. y-axis label.}

\item{type}{Character scalar. See \code{\link{par}}.}

\item{bg}{Character scalar. Color of the points.}

\item{pch}{Integer scalar. See \code{\link{par}}.}

\item{add}{Logical scalar. When TRUE it adds the hazard rate to the current plot.}

\item{ylim}{Numeric vector. See \code{\link{plot}}.}
}
\value{
A row vector of size \eqn{T} with hazard rates for \eqn{t>1} of class \code{diffnet_hr}.
The class of the object is only used by the S3 plot method.
}
\description{
The hazard rate is the instantaneous probability of adoption at each time
representing the likelihood members will adopt at that time (Allison 1984).
The shape of the hazard rate indicates the pattern of new adopters over time.
Rapid diffusion with convex cumulative adoption curves will have hazard functions
that peak early and decay over time whereas slow concave cumulative adoption
curves will have hazard functions that are low early and rise over time.
Smooth hazard curves indicate constant adoption whereas those that oscillate
indicate variability in adoption behavior over time.
}
\details{
This function computes hazard rate, plots it and returns the hazard rate vector
invisible (so is not printed on the console). For \eqn{t>1}, hazard rate is calculated as

\deqn{\frac{q_t - q_{t-1}}{n - q_{t-1}}}{[q(t) - q(t-1)]/[n - q(t-1)]}

where \eqn{q_i}{q(i)} is the number of adopters in time \eqn{t}, and \eqn{n} is
the number of vertices in the graph.

In survival analysis, hazard rate is defined formally as

\deqn{%
\lambda(t)=\lim_{h\to +0}\frac{F(t+h)-F(t)}{h}\frac{1}{1-F(t)} %
}{%
\lambda(t-1)= lim (t -> +0) [F(t+h)-F(t)]/h * 1/[1-F(t)] %
}

Then, by approximating \eqn{h=1}, we can rewrite the equation as

\deqn{%
\lambda(t)=\frac{F(t+1)-F(t)}{1-F(t)} %
}{%
\lambda(t-1)= [F(t+1)-F(t)]/[1-F(t)] %
}

Furthermore, we can estimate \eqn{F(t)}, the probability of not having adopted
the innovation in time \eqn{t}, as the proportion of adopters in that time, this
is \eqn{F(t) \sim q_t/n}{F(t) ~ q(t)/n}, so now we have

\deqn{%
\lambda(t)=\frac{q_{t+1}/n-q_t/n}{1-q_t/n} = \frac{q_{t+1} - q_t}{n - q_t} %
}{%
\lambda(t-1)= [q(t+1)/n-q(t)/n]/[1-q(t)/n] = [q(t+1) - q(t)]/[n - q(t)] %
}

As showed above.

The \code{plot_hazard} function is an alias for the \code{plot.diffnet_hr} method.
}
\examples{
# Creating a random vector of times of adoption
toa <- sample(2000:2005, 20, TRUE)

# Computing cumulative adoption matrix
cumadopt <- toa_mat(toa)$cumadopt

# Visualizing the hazard rate
hazard_rate(cumadopt)
}
\references{
Allison, P. (1984). Event history analysis regression for longitudinal event
data. Beverly Hills: Sage Publications.

Wooldridge, J. M. (2010). Econometric Analysis of Cross Section and Panel Data
(2nd ed.). Cambridge: MIT Press.
}
\seealso{
Other statistics: \code{\link{bass}},
  \code{\link{classify_adopters}},
  \code{\link{cumulative_adopt_count}}, \code{\link{dgr}},
  \code{\link{ego_variance}}, \code{\link{exposure}},
  \code{\link{infection}}, \code{\link{moran}},
  \code{\link{struct_equiv}}, \code{\link{threshold}},
  \code{\link{vertex_covariate_dist}}

Other visualizations: \code{\link{dgr}},
  \code{\link{diffusionMap}}, \code{\link{drawColorKey}},
  \code{\link{grid_distribution}},
  \code{\link{plot_adopters}}, \code{\link{plot_diffnet2}},
  \code{\link{plot_diffnet}},
  \code{\link{plot_infectsuscep}},
  \code{\link{plot_threshold}},
  \code{\link{rescale_vertex_igraph}}
}
\author{
George G. Vega Yon & Thomas W. Valente
}
\concept{statistics}
\concept{visualizations}
\keyword{univar}
