% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.netbind.R
\name{print.netbind}
\alias{print.netbind}
\title{Print method for objects of class netbind}
\usage{
\method{print}{netbind}(x, comb.fixed = x$comb.fixed, comb.random = x$comb.random, ...)
}
\arguments{
\item{x}{An object of class \code{netbind} or
\code{summary.netbind}.}

\item{comb.fixed}{A logical indicating whether results for the
fixed effects (common effects) model should be printed.}

\item{comb.random}{A logical indicating whether results for the
random effects model should be printed.}

\item{\dots}{Additional arguments (ignored).}
}
\description{
Print method for objects of class \code{netbind}.
}
\examples{
data(Linde2016)

# Only consider studies including Face-to-face PST (to reduce
# runtime of example)
#
face <- subset(Linde2016, id \%in\% c(16, 24, 49, 118))

# Standard random effects NMA model (with placebo as reference
# treatment)
#
net1 <- netmeta(lnOR, selnOR, treat1, treat2, id,
                data = face, reference.group = "placebo",
                sm = "OR", comb.fixed = FALSE)

# Additive CNMA model with placebo as inactive component and
# reference
#
nc1 <- netcomb(net1, inactive = "placebo")

# Combine results of standard NMA and CNMA
#
nb1 <- netbind(nc1, net1,
               name = c("Additive CNMA", "Standard NMA"),
               col.study = c("red", "black"),
               col.square = c("red", "black"))

nb1
print(nb1, comb.fixed = TRUE)

}
\seealso{
\code{\link{netbind}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
