% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nettskjema-codebook.R
\name{get_raw_codebook}
\alias{get_raw_codebook}
\title{Get the raw codebook}
\usage{
get_raw_codebook(form_id, token_name = "NETTSKJEMA_API_TOKEN", ...)
}
\arguments{
\item{form_id}{integer. Number of the form to retrieve}

\item{token_name}{character. Name to give the token, defaults to 'NETTSKJEMA_API_TOKEN'}

\item{...}{other arguments to \code{\link[httr]{GET}}}
}
\value{
long format tibble with meta-data for a specific nettskjema
}
\description{
The raw codebook is a list
of answers and questions with
unique ids for both, and the text associated
with them. This information can be retrieved
from the raw nettskjema data. This can be useful
if the nettskjema submission data has been returned
with \code{as_is = TRUE}.
}
\examples{
\dontrun{
form_id <- 100000
get_raw_codebook(form_id)

Or if the token is saved in a non-standard name
get_raw_codebook(form_id, token_name = "MY_NETTSKJEMA_TOKEN_NAME")
}
}
