% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{depression}
\alias{depression}
\title{Simulated Depression Profiles}
\format{a dataframe. Columns represent symptoms and rows represent individuals}
\usage{
depression
}
\description{
This simulated dataset contains severity ratings for 9 symptoms of major depressive
disorder in 1000 individuals. Symptom ratings are  assumed to be self-reported
on a 100 point sliding scale.
}
\examples{
head(depression)
\donttest{
out1 <- impact(depression)
summary(out1)
plot(out1)

out2 <- edge.impact(depression, gamma=0.75, nodes=c("sleep_disturbance", "psychomotor_retardation"))
summary(out2)
plot(out2)

# Visualize depression networks for "low" psychomotor retardation vs. "high" psychomotor retardation
par(mfrow=c(1,2))
qgraph::qgraph(out2$lo$psychomotor_retardation, title="Low Psychomotor Retardation")
qgraph::qgraph(out2$hi$psychomotor_retardation, title="High Psychomotor Retardation")
}

}
\keyword{datasets}
