% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_impact.R
\name{global.impact}
\alias{global.impact}
\title{Global Strength Impact}
\usage{
global.impact(input, gamma, nodes = c("all"), binary.data = FALSE,
  weighted = TRUE, split = c("median", "mean", "forceEqual",
  "cutEqual", "quartiles"))
}
\arguments{
\item{input}{a matrix or data frame of observations (not a network/edgelist).
See included example datasets \code{\link{depression}} and \code{\link{social}}.}

\item{gamma}{the sparsity parameter used in generating networks. Defaults to 0.5 for interval data
and 0.25 for binary data}

\item{nodes}{indicates which nodes should be tested. Can be given
as a character string of desired nodes (e.g., c("node1","node2")) or as a numeric vector of
column numbers (e.g., c(1,2)).}

\item{binary.data}{logical. Indicates whether the input data is binary}

\item{weighted}{logical. Indicates whether resultant networks preserve edge weights or binarize edges.}

\item{split}{method by which to split network given non-binary data. "median": median split (excluding the median),
"mean": mean split, "forceEqual": creates equally sized groups by partitioning random median observations
 to the smaller group, "cutEqual": creates equally sized groups by deleting random values
 from the bigger group,"quartile": uses the top and bottom quartile as groups}
}
\value{
\code{global.impact()} returns a list of class "\code{global.impact}" which contains:
 \item{impact}{a named vector containing the global strength impact for each node tested}
 \item{lo}{a named vector containing the global strength estimate for the lower half}
 \item{hi}{a named vector containing the global strength estimate for the upper half}
}
\description{
This function is DEPRECATED and will be replaced by impact().
}
\details{
Generates the global strength impact of each specified node. Global strength impact can be interpreted
as the degree to which the level of a node impacts the overall connectivity of the network



For an explanation of impact functions in general, see \code{\link{impact}}.

Global strength is defined as the sum of the absolute value
of all edges in the network, and is closely related to the concept of density (density is the
sum of edges not accounting for absolute values). Global strength impact measures to what degree
the global strength varies as a function of each node.
}
